import { Component, OnInit } from '@angular/core';
import { VehicleType } from '../vehicleTypeModelDefinition';
import { vehicleTypeModelInitializer } from '../vehicleTypeModelInitializer';
import { Router } from '@angular/router';
import { VehicleTypeService } from '../vehicle-type.service';
import { ToastrService } from 'ngx-toastr';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { isAppInOfflineMode } from 'src/environments/app-settings';

@Component({
  selector: 'app-vehicle-type',
  templateUrl: './vehicle-type.component.html',
  styleUrls: ['./vehicle-type.component.scss']
})
export class VehicleTypeComponent implements OnInit {
  constructor(private vehicleTypeService: VehicleTypeService, private router: Router, private toastr: ToastrService) { }
  
  tableRows: string[]=["#","Name",""]
  vehicleTypes: VehicleType[]= isAppInOfflineMode() ? [] :  vehicleTypeModelInitializer.vehicleTypes

  ngOnInit(): void {
    this.getVehicleTypes()
  }

  getVehicleTypes(){
    this.vehicleTypeService.getVehicleTypes().subscribe({
      next: (vehicleTypes) => this.vehicleTypes = vehicleTypes,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  deleteVehicleType(vehicleTypeId: number){
    this.vehicleTypeService.deleteVehicleType(vehicleTypeId).subscribe({
      next: (isDeleted) => {
        reloadCurrentRoute(this.router)
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
