import { Component, OnInit } from '@angular/core';
import { WarehouseService } from '../warehouse.service';
import { Router } from '@angular/router';
import { warehouseModelInitializer } from '../warehouseModelInitializer';
import { Warehouse } from '../warehouseModelDefinition';
import { cloneDeep } from 'lodash';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-warehouse-create',
  templateUrl: './warehouse-create.component.html',
  styleUrls: ['./warehouse-create.component.scss']
})
export class WarehouseCreateComponent implements OnInit {
constructor(private warehouseService: WarehouseService, private router: Router, private toastr: ToastrService) { }

  disableWarehouse: boolean = true;
  warehouse: Warehouse = cloneDeep(warehouseModelInitializer.createWarehouse)

  ngOnInit(): void {
  }

  insertWarehouse(event: string): void{
    event != "" ? this.disableWarehouse = false : this.disableWarehouse = true
  }

  createWarehouse(): void{
    this.warehouseService.createWarehouse(this.warehouse).subscribe({
      next: (createdWarehouse) => {
        this.router.navigate(['/warehouse'])
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
