import { Component, OnInit } from '@angular/core';
import { warehouseModelInitializer } from '../warehouseModelInitializer';
import { Warehouse, WarehouseDetails } from '../warehouseModelDefinition';
import { WarehouseService } from '../warehouse.service';
import { ToastrService } from 'ngx-toastr';
import { Router } from '@angular/router';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { isAppInOfflineMode } from 'src/environments/app-settings';

@Component({
  selector: 'app-warehouse',
  templateUrl: './warehouse.component.html',
  styleUrls: ['./warehouse.component.scss']
})
export class WarehouseComponent implements OnInit {

  constructor(private warehouseService: WarehouseService, private router: Router, private toastr: ToastrService) { }

  tableRows: string[]=["#","Name","Address", ""]
  warehouses: WarehouseDetails[]= isAppInOfflineMode() ? [] :  warehouseModelInitializer.warehouses

 ngOnInit(): void {
    this.getWarehouses()
  }

  getWarehouses(){
    this.warehouseService.getWarehouses().subscribe({
      next: (warehouses) => this.warehouses = warehouses,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  deleteWarehouse(warehouseId: number, addressId: number){
    this.warehouseService.deleteWarehouse(warehouseId, addressId).subscribe({
      next: (isDeleted) => {
        reloadCurrentRoute(this.router)
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
