import { ToastrService } from "ngx-toastr";
import { ErrorHandlerModel } from "src/app/models";

export function ShowErrorToaster(toastr: ToastrService, response: any){
    let error: ErrorHandlerModel = response.error
    if(error.name != undefined) toastr.error(error.description, error.name, {positionClass: 'toast-bottom-right'})
    else toastr.error(response.error, "An error occured with the action.", {positionClass: 'toast-bottom-right'})
}

export function ShowSuccessToaster(toastr: ToastrService){
    toastr.success("Action was completed successfully.", "Success", {positionClass: 'toast-bottom-right'})
}