import { Router } from "@angular/router";
import { reloadCurrentRoute } from "./RouteHelper";
import { OTPCodes } from "src/app/enums";
import { ToastrService } from "ngx-toastr";

export function authorizeUser(authCode: string, router: Router, toastr: ToastrService){
    let formatedAuthCode = authCode?.trim().toUpperCase()
    let authCodeExistsInCodesList = Object.values(OTPCodes).some((x: string) => x == formatedAuthCode);

    if(authCodeExistsInCodesList && formatedAuthCode.length == 6){
        sessionStorage.setItem('authorizationCode', formatedAuthCode);

        var closeModalButton = document.getElementById("CloseModalButton") as HTMLElement
        closeModalButton.click();

        reloadCurrentRoute(router)

        toastr.success(
            'The Authorization Code you entered is valid. Welcome to the app.',
              'Authorization Successfull',
              {positionClass: 'toast-bottom-right'})
    }
    else{
        toastr.error(
            'The Authorization Code you entered does not exist, Please enter another one.',
              'Invalid Authorization Code',
              {positionClass: 'toast-bottom-right'})
    }
}

export function userIsManager(): boolean{
    let authorizationCode = sessionStorage.getItem('authorizationCode');
    let isManager = authorizationCode == OTPCodes.Manager ? true : false

    return isManager;   
}

export function userIsStorekeeper(){
    let authorizationCode = sessionStorage.getItem('authorizationCode');
    let isStorekeeper = authorizationCode == OTPCodes.Storekeeper ? true : false
    
    return isStorekeeper;   
}

export function clearUserAuthorization(router: Router, toastr: ToastrService){
    sessionStorage.removeItem('authorizationCode');
    if(router.url != '/shipment') setTimeout(() => router.navigate(['/shipment']), 0);
    reloadCurrentRoute(router)

    toastr.success(
        'The Authorization Code is cleared successfully',
          'Authorization Cleared Succesfully',
          {positionClass: 'toast-bottom-right'})
}

export function  workMode(): string{
    let authorizationCode = sessionStorage.getItem('authorizationCode');

    if(authorizationCode == OTPCodes.Manager)
      return "Manager Mode"
    else if(authorizationCode == OTPCodes.Storekeeper){
      return "Storekeeper Mode"
    }
    else{
      return "Delivery Person Mode"
    }
}