import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { CustomerType } from './customerTypeModelDefinition';
import { AppSettings } from 'src/environments/app-settings';

@Injectable({
  providedIn: 'root'
})
export class CustomerTypeService {
private apiUrl = AppSettings.ApiUrl + 'CustomerType'; // Update with your actual port

  constructor(private http: HttpClient) { }

  getCustomerTypes(): Observable<CustomerType[]> {
    return this.http.get<CustomerType[]>(this.apiUrl);
  }

  getCustomerType(id: number): Observable<CustomerType> {
    return this.http.get<CustomerType>(this.apiUrl + '/' + id);
  }

  createCustomerType(customerType: CustomerType): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl, customerType);
  }

  updateCustomerType(customerType: CustomerType): Observable<boolean> {
    return this.http.put<boolean>(this.apiUrl, customerType);
  }

  deleteCustomerType(id: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/' + id);
  }
}
