import { Component, OnInit } from '@angular/core';
import { employeeModelInitializer } from '../employeeModelInitializer';
import { EmployeeService } from '../employee.service';
import { Employee } from '../employeeModelDefinition';
import { WarehouseDetails } from 'src/app/WarehouseEntity/warehouseModelDefinition';
import { WarehouseService } from 'src/app/WarehouseEntity/warehouse.service';
import { ActivatedRoute, Router } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-employee-edit',
  templateUrl: './employee-edit.component.html',
  styleUrls: ['./employee-edit.component.scss']
})
export class EmployeeEditComponent implements OnInit {
constructor(private employeeService: EmployeeService, private warehouseService: WarehouseService, private router: Router, private route: ActivatedRoute, private toastr: ToastrService) { }

  disableEmployee: boolean = true;
  employee: Employee = employeeModelInitializer.createEmployee
  employeeId: number = 0;
  warehouses: WarehouseDetails[] = [];
  
  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.employeeId = Number(params.get('employeeId'));
    });
  
     this.getEmployee(this.employeeId);
     this.getWarehouses();
  }
    
  insertEmployee(event: string): void{
     event != "" ? this.disableEmployee = false : this.disableEmployee = true
  }
    
  editEmployee(): void{
    this.employeeService.updateEmployee(this.employee).subscribe({
       next: (isUpdated) => {
         this.router.navigate(['/employee']);
         ShowSuccessToaster(this.toastr)
       },
       error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
  
  getEmployee(employeeId: number): void{
    this.employeeService.getEmployee(employeeId).subscribe({
      next: (employee) => this.employee = employee,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getWarehouses(){
    this.warehouseService.getWarehouses().subscribe({
      next: (warehouses) => this.warehouses = warehouses,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
