import { Component, OnInit } from '@angular/core';
import { ExpenseType } from '../expenseTypeModelDefinition';
import { expenseTypeModelInitializer } from '../expenseTypeModelInitializer';
import { ToastrService } from 'ngx-toastr';
import { ExpenseTypeService } from '../expense-type.service';
import { Router } from '@angular/router';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { isAppInOfflineMode } from 'src/environments/app-settings';

@Component({
  selector: 'app-expense-type',
  templateUrl: './expense-type.component.html',
  styleUrls: ['./expense-type.component.scss']
})
export class ExpenseTypeComponent implements OnInit {

  constructor(private expenseTypeService: ExpenseTypeService, private router: Router, private toastr: ToastrService) { }
  
  tableRows: string[]=["#","Name","Description",""]
  expenseTypes: ExpenseType[]= isAppInOfflineMode() ? [] :  expenseTypeModelInitializer.expenseTypes
  ngOnInit(): void {
    this.getExpenseTypes()
  }

  getExpenseTypes(){
    this.expenseTypeService.getExpenseTypes().subscribe({
      next: (expenseTypes) => this.expenseTypes = expenseTypes,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  deleteExpenseType(expenseTypeId: number){
    this.expenseTypeService.deleteExpenseType(expenseTypeId).subscribe({
      next: (isDeleted) => {
        reloadCurrentRoute(this.router)
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
