import { Component, OnInit } from '@angular/core';
import { ShipmentService } from '../shipment.service';
import { Shipment, ShipmentPreview } from 'src/app/ShipmentEntity/shipmentModelDefinition';
import { shipmentModelInitializer } from '../shipmentModelInitializer';
import { cloneDeep } from 'lodash';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { Router } from '@angular/router';
import { userIsManager, userIsStorekeeper } from 'src/assets/UserAuthorizationHelper';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { ToastrService } from 'ngx-toastr';
import { isAppInOfflineMode } from 'src/environments/app-settings';

@Component({
  selector: 'app-shipment',
  templateUrl: './shipment.component.html',
  styleUrls: ['./shipment.component.scss']
})
export class ShipmentComponent implements OnInit {

  constructor(private shipmentService: ShipmentService, private router: Router, private toastr: ToastrService) { }
  tableRows: string[] = ["#","Shipment Date", "Customer","Employee","Vehicle",""];
  shipments: ShipmentPreview[] =  isAppInOfflineMode() ? [] : shipmentModelInitializer.shipments;

  filterShipmentDate: string = "";
  filterEmployeeNameSurname: string= "";
  filterRegistration: string = "";

  ngOnInit(): void {
    this.getShipments("","","");
  }

  getShipments(filterShipmentDate: string, filterEmployeeNameSurname: string, filterRegistration: string): void {
    this.shipmentService.getShipments(filterShipmentDate,filterEmployeeNameSurname,filterRegistration).subscribe({
      next: (data) => this.shipments = data,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  clearFilters(){
    this.filterShipmentDate = ""
    this.filterEmployeeNameSurname = ""
    this.filterRegistration = ""
    this.getShipments("","","")
  }

  payShipment(paymentId: number){
    this.shipmentService.payShipment(paymentId).subscribe({
      next: (data) => {
        reloadCurrentRoute(this.router)
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  deleteShipment(shipmentId: string, paymentId: number){
    this.shipmentService.deleteShipment(Number(shipmentId), paymentId).subscribe({
      next: (data) => {
        reloadCurrentRoute(this.router)
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  userIsManager(): boolean{
    return userIsManager();
  }
  
  userIsStorekeeper(): boolean{
    return userIsStorekeeper()
  }
}
