import { Component, OnInit } from '@angular/core';
import { VehicleDetailsService } from '../vehicle-details.service';
import { ActivatedRoute, Router } from '@angular/router';
import { VehicleTypeService } from 'src/app/VehicleTypeEntity/vehicle-type.service';
import { vehicleDetailsModelInitializer } from '../vehicleDetailsModelInitializer';
import { VehicleDetails } from '../VehicleDetailsModelDefinition';
import { VehicleType } from 'src/app/VehicleTypeEntity/vehicleTypeModelDefinition';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-vehicle-details-edit',
  templateUrl: './vehicle-details-edit.component.html',
  styleUrls: ['./vehicle-details-edit.component.scss']
})
export class VehicleDetailsEditComponent implements OnInit {
constructor(private vehicleDetailsService: VehicleDetailsService, private vehicleTypeService: VehicleTypeService, private router: Router, private route: ActivatedRoute, private toastr: ToastrService) { }

  disableVehicleDetails: boolean = true;
  vehicleDetails: VehicleDetails = vehicleDetailsModelInitializer.createVehicleDetails
  vehicleDetailsId: number = 0;
  vehicleTypes: VehicleType[] = [];
  
  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.vehicleDetailsId = Number(params.get('vehicleDetailsId'));
    });

    this.getVehicleDetails(this.vehicleDetailsId);
    this.getVehicleTypes();
  }
  
  insertVehicleDetails(event: string): void{
    event != "" ? this.disableVehicleDetails = false : this.disableVehicleDetails = true
  }
  
  editVehicleDetails(): void{
    this.vehicleDetailsService.updateVehicleDetails(this.vehicleDetails).subscribe({
      next: (isUpdated) => {
        this.router.navigate(['/vehicleDetails']);
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getVehicleDetails(vehicleDetailsId: number): void{
    this.vehicleDetailsService.getVehicleDetails(vehicleDetailsId).subscribe({
      next: (vehicleDetails) => {
        this.vehicleDetails = vehicleDetails
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getVehicleTypes(){
    this.vehicleTypeService.getVehicleTypes().subscribe({
      next: (vehicleTypes) => this.vehicleTypes = vehicleTypes,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
