import { Component, OnInit } from '@angular/core';
import { VehicleDetails } from 'src/app/VehicleDetailsEntity/VehicleDetailsModelDefinition';
import { Vehicle } from '../vehicleModelDefinition';
import { vehicleModelInitializer } from '../vehicleModelInitializer';
import { ActivatedRoute, Router } from '@angular/router';
import { VehicleDetailsService } from 'src/app/VehicleDetailsEntity/vehicle-details.service';
import { VehicleService } from '../vehicle.service';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { ToastrService } from 'ngx-toastr';

@Component({
  selector: 'app-vehicle-edit',
  templateUrl: './vehicle-edit.component.html',
  styleUrls: ['./vehicle-edit.component.scss']
})
export class VehicleEditComponent implements OnInit {
constructor(private vehicleService: VehicleService, private vehicleDetailsService: VehicleDetailsService, private router: Router, private route: ActivatedRoute, private toastr: ToastrService) { }

  disableVehicle: boolean = true;
  vehicle: Vehicle = vehicleModelInitializer.createVehicle
  vehicleId: number = 0;
  vehicleDetails: VehicleDetails[] = [];
  
  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.vehicleId = Number(params.get('vehicleId'));
    });

    this.getVehicle(this.vehicleId);
    this.getVehicleDetails();
  }
  
  insertVehicle(event: string): void{
    event != "" ? this.disableVehicle = false : this.disableVehicle = true
  }
  
  editVehicle(): void{
    this.vehicleService.updateVehicle(this.vehicle).subscribe({
      next: (isUpdated) => {
        this.router.navigate(['/vehicle']);
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getVehicle(vehicleId: number): void{
    this.vehicleService.getVehicle(vehicleId).subscribe({
      next: (vehicle) => this.vehicle = vehicle,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getVehicleDetails(){
    this.vehicleDetailsService.getAllVehicleDetails().subscribe({
      next: (vehicleDetails) => this.vehicleDetails = vehicleDetails,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
