import { Component, OnInit } from '@angular/core';
import { VehicleType } from '../vehicleTypeModelDefinition';
import { vehicleTypeModelInitializer } from '../vehicleTypeModelInitializer';
import { VehicleTypeService } from '../vehicle-type.service';
import { Router } from '@angular/router';
import { cloneDeep } from 'lodash';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-vehicle-type-create',
  templateUrl: './vehicle-type-create.component.html',
  styleUrls: ['./vehicle-type-create.component.scss']
})
export class VehicleTypeCreateComponent implements OnInit {
  constructor(private vehicleTypeService: VehicleTypeService, private router: Router, private toastr: ToastrService) { }

  disableVehicleType: boolean = true;
  vehicleType: VehicleType = cloneDeep(vehicleTypeModelInitializer.createVehicleType)

  ngOnInit(): void {
  }

  insertVehicleType(event: string): void{
    event != "" ? this.disableVehicleType = false : this.disableVehicleType = true
  }

  createVehicleType(): void{
    this.vehicleTypeService.createVehicleType(this.vehicleType).subscribe({
      next: (createdVehicleType) => {
        this.router.navigate(['/vehicleType'])
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
