import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { warehouseModelInitializer } from '../warehouseModelInitializer';
import { WarehouseService } from '../warehouse.service';
import { Warehouse } from '../warehouseModelDefinition';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-warehouse-edit',
  templateUrl: './warehouse-edit.component.html',
  styleUrls: ['./warehouse-edit.component.scss']
})
export class WarehouseEditComponent implements OnInit {
constructor(private warehouseService: WarehouseService, private router: Router, private route: ActivatedRoute, private toastr: ToastrService) { }

  disableWarehouse: boolean = true;
  warehouse: Warehouse = warehouseModelInitializer.createWarehouse
  warehouseId: number = 0;

  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.warehouseId = Number(params.get('warehouseId'));
    });

    this.getWarehouse(this.warehouseId);
  }
  
  insertWarehouse(event: string): void{
    event != "" ? this.disableWarehouse = false : this.disableWarehouse = true
  }
  
  editWarehouse(): void{
    this.warehouseService.updateWarehouse(this.warehouse).subscribe({
      next: (isUpdated) => {
        this.router.navigate(['/warehouse']);
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getWarehouse(warehouseId: number): void{
    this.warehouseService.getWarehouse(warehouseId).subscribe({
      next: (warehouse) => this.warehouse = warehouse,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
