import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { AppSettings } from 'src/environments/app-settings';
import { Warehouse, WarehouseDetails } from './warehouseModelDefinition';

@Injectable({
  providedIn: 'root'
})
export class WarehouseService {
 private apiUrl = AppSettings.ApiUrl + 'Warehouse'; // Update with your actual port

  constructor(private http: HttpClient) { }

  getWarehouses(): Observable<WarehouseDetails[]> {
    return this.http.get<WarehouseDetails[]>(this.apiUrl);
  }

  getWarehouse(id: number): Observable<Warehouse> {
    return this.http.get<Warehouse>(this.apiUrl + '/' + id);
  }

  createWarehouse(warehouse: Warehouse): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl, warehouse);
  }

  updateWarehouse(warehouse: Warehouse): Observable<boolean> {
    return this.http.put<boolean>(this.apiUrl, warehouse);
  }

  deleteWarehouse(warehouseId: number, addressId: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/' + warehouseId + '/' + addressId);
  }
}
