import { Component, OnInit } from '@angular/core';
import { WineService } from '../wine.service';
import { Router } from '@angular/router';
import { wineModelInitializer } from '../wineModelInitializer';
import { cloneDeep } from 'lodash';
import { Wine } from '../wineModelDefinition';
import { WineTypeService } from 'src/app/WineTypeEntity/wine-type.service';
import { WineType } from 'src/app/WineTypeEntity/winetypeModelDefinition';
import { ToastrService } from 'ngx-toastr';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';

@Component({
  selector: 'app-wine-create',
  templateUrl: './wine-create.component.html',
  styleUrls: ['./wine-create.component.scss']
})
export class WineCreateComponent implements OnInit {
constructor(private wineService: WineService, private wineTypeService: WineTypeService, private router: Router, private toastr: ToastrService) { }

  disableWine: boolean = true;
  wine: Wine = cloneDeep(wineModelInitializer.createWine)
  wineTypes: WineType[] = [];

  ngOnInit(): void {
    this.getWineTypes();
  }

  insertWine(event: string): void{
    event != "" ? this.disableWine = false : this.disableWine = true
  }

  createWine(): void{
    this.wineService.createWine(this.wine).subscribe({
      next: (createdWine) => {
        this.router.navigate(['/wine'])
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }

  getWineTypes(){
    this.wineTypeService.getWineTypes().subscribe({
      next: (wineTypes) => {
        this.wineTypes = wineTypes
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
