import { Component, OnInit } from '@angular/core';
import { wineModelInitializer } from '../wineModelInitializer';
import { Wine } from '../wineModelDefinition';
import { Router } from '@angular/router';
import { WineService } from '../wine.service';
import { ToastrService } from 'ngx-toastr';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { isAppInOfflineMode } from 'src/environments/app-settings';

@Component({
  selector: 'app-wine',
  templateUrl: './wine.component.html',
  styleUrls: ['./wine.component.scss']
})
export class WineComponent implements OnInit {
  constructor(private wineService: WineService, private router: Router, private toastr: ToastrService) { }

  tableRows: string[]=["#","Name","Type","Base Price","Year Produced", ""]
  wines: Wine[]=  isAppInOfflineMode() ? [] : wineModelInitializer.wines

  ngOnInit(): void {
    this.getWines()
  }
  
  getWines(){
    this.wineService.getWines().subscribe({
      next: (wines) => this.wines = wines,
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
    
  deleteWine(wineId: number){
    this.wineService.deleteWine(wineId).subscribe({
      next: (isDeleted) => {
        reloadCurrentRoute(this.router)
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
