import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { AppSettings } from 'src/environments/app-settings';
import { WineType } from './winetypeModelDefinition';

@Injectable({
  providedIn: 'root'
})
export class WineTypeService {
 private apiUrl = AppSettings.ApiUrl + 'WineType'; // Update with your actual port

  constructor(private http: HttpClient) { }

  getWineTypes(): Observable<WineType[]> {
    return this.http.get<WineType[]>(this.apiUrl);
  }

  getWineType(id: number): Observable<WineType> {
    return this.http.get<WineType>(this.apiUrl + '/' + id);
  }

  createWineType(wineType: WineType): Observable<boolean> {
    return this.http.post<boolean>(this.apiUrl, wineType);
  }

  updateWineType(wineType: WineType): Observable<boolean> {
    return this.http.put<boolean>(this.apiUrl, wineType);
  }

  deleteWineType(id: number): Observable<boolean> {
    return this.http.delete<boolean>(this.apiUrl + '/' + id);
  }
}
