import { Component, OnInit } from '@angular/core';
import {wineTypeModelInitializer } from '../winetypeModelInitializer';
import { WineType } from '../winetypeModelDefinition';
import { ToastrService } from 'ngx-toastr';
import { Router } from '@angular/router';
import { WineTypeService } from '../wine-type.service';
import { reloadCurrentRoute } from 'src/assets/RouteHelper';
import { ShowErrorToaster, ShowSuccessToaster } from 'src/assets/ErrorHandler';
import { isAppInOfflineMode } from 'src/environments/app-settings';

@Component({
  selector: 'app-wine-type',
  templateUrl: './wine-type.component.html',
  styleUrls: ['./wine-type.component.scss']
})
export class WineTypeComponent implements OnInit {

  constructor(private wineTypeService: WineTypeService, private router: Router, private toastr: ToastrService) { }

  tableRows: string[]=["#","Name","Description","Region",""]
  wineTypes: WineType[]= isAppInOfflineMode() ? [] :  wineTypeModelInitializer.wineTypes

  ngOnInit(): void {
    this.getWineTypes()
  }

  getWineTypes(){
    this.wineTypeService.getWineTypes().subscribe({
      next: (wineTypes) => this.wineTypes = wineTypes,
      error: (error) => console.error('Error getting Wine Types:', error)
    });
  }
  
  deleteWineType(wineTypeId: number){
    this.wineTypeService.deleteWineType(wineTypeId).subscribe({
      next: (isDeleted) => {
        reloadCurrentRoute(this.router)
        ShowSuccessToaster(this.toastr)
      },
      error: (response) => ShowErrorToaster(this.toastr, response)
    });
  }
}
