import { NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import { FormsModule } from '@angular/forms';
import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { NoopAnimationsModule } from '@angular/platform-browser/animations';
import { HomeComponent } from './home/home.component';
import { HttpClientModule } from '@angular/common/http';
import { CustomerComponent } from './CustomerEntity/customer/customer.component';
import { EmployeeComponent } from './EmployeeEntity/employee/employee.component';
import { VehicleComponent } from './VehicleEntity/vehicle/vehicle.component';
import { WarehouseComponent } from './WarehouseEntity/warehouse/warehouse.component';
import { WineComponent } from './WineEntity/wine/wine.component';
import { CustomerTypeComponent } from './CustomerTypeEntity/customer-type/customer-type.component';
import { WineTypeComponent } from './WineTypeEntity/wine-type/wine-type.component';
import { ExpenseTypeComponent } from './ExpenseTypeEntity/expense-type/expense-type.component';
import { VehicleTypeComponent } from './VehicleTypeEntity/vehicle-type/vehicle-type.component';
import { ShipmentComponent } from './ShipmentEntity/shipment/shipment.component';
import { ShipmentCreateComponent } from './ShipmentEntity/shipment-create/shipment-create.component';
import { ShipmentDetailsComponent } from './ShipmentEntity/shipment-details/shipment-details.component';
import { VehicleTypeCreateComponent } from './VehicleTypeEntity/vehicle-type-create/vehicle-type-create.component';
import { VehicleTypeEditComponent } from './VehicleTypeEntity/vehicle-type-edit/vehicle-type-edit.component';
import { ToastrModule, ToastContainerModule } from 'ngx-toastr';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { ExpenseTypeCreateComponent } from './ExpenseTypeEntity/expense-type-create/expense-type-create.component';
import { ExpenseTypeEditComponent } from './ExpenseTypeEntity/expense-type-edit/expense-type-edit.component';
import { WineTypeCreateComponent } from './WineTypeEntity/wine-type-create/wine-type-create.component';
import { WineTypeEditComponent } from './WineTypeEntity/wine-type-edit/wine-type-edit.component';
import { CustomerTypeCreateComponent } from './CustomerTypeEntity/customer-type-create/customer-type-create.component';
import { CustomerTypeEditComponent } from './CustomerTypeEntity/customer-type-edit/customer-type-edit.component';
import { WarehouseCreateComponent } from './WarehouseEntity/warehouse-create/warehouse-create.component';
import { WarehouseEditComponent } from './WarehouseEntity/warehouse-edit/warehouse-edit.component';
import { WineCreateComponent } from './WineEntity/wine-create/wine-create.component';
import { WineEditComponent } from './WineEntity/wine-edit/wine-edit.component';
import { CustomerCreateComponent } from './CustomerEntity/customer-create/customer-create.component';
import { CustomerEditComponent } from './CustomerEntity/customer-edit/customer-edit.component';
import { VehicleDetailsComponent } from './VehicleDetailsEntity/vehicle-details/vehicle-details.component';
import { VehicleDetailsCreateComponent } from './VehicleDetailsEntity/vehicle-details-create/vehicle-details-create.component';
import { VehicleDetailsEditComponent } from './VehicleDetailsEntity/vehicle-details-edit/vehicle-details-edit.component';
import { VehicleCreateComponent } from './VehicleEntity/vehicle-create/vehicle-create.component';
import { VehicleEditComponent } from './VehicleEntity/vehicle-edit/vehicle-edit.component';
import { ReportsComponent } from './Reports/reports/reports.component';
import { EmployeeCreateComponent } from './EmployeeEntity/employee-create/employee-create.component';
import { EmployeeEditComponent } from './EmployeeEntity/employee-edit/employee-edit.component';
import { EmployeeAddVehicleComponent } from './EmployeeEntity/employee-add-vehicle/employee-add-vehicle.component';
import { ShipmentAddExpenseComponent } from './ShipmentEntity/shipment-add-expense/shipment-add-expense.component';
import { ShipmentEditComponent } from './ShipmentEntity/shipment-edit/shipment-edit.component';

@NgModule({
  declarations: [
    AppComponent,
    ShipmentComponent,
    HomeComponent,
    ShipmentCreateComponent,
    ShipmentDetailsComponent,
    CustomerComponent,
    EmployeeComponent,
    VehicleComponent,
    WarehouseComponent,
    WineComponent,
    CustomerTypeComponent,
    CustomerTypeCreateComponent,
    CustomerTypeEditComponent,
    WineTypeComponent,
    ExpenseTypeComponent,
    VehicleTypeComponent,
    VehicleTypeCreateComponent,
    VehicleTypeEditComponent,
    ExpenseTypeCreateComponent,
    ExpenseTypeEditComponent,
    WineTypeCreateComponent,
    WineTypeEditComponent,
    WarehouseCreateComponent,
    WarehouseEditComponent,
    WineCreateComponent,
    WineEditComponent,
    CustomerCreateComponent,
    CustomerEditComponent,
    VehicleDetailsComponent,
    VehicleDetailsCreateComponent,
    VehicleDetailsEditComponent,
    VehicleCreateComponent,
    VehicleEditComponent,
    ReportsComponent,
    EmployeeCreateComponent,
    EmployeeEditComponent,
    EmployeeAddVehicleComponent,
    ShipmentAddExpenseComponent,
    ShipmentEditComponent,
  ],
  imports: [
    BrowserModule,
    AppRoutingModule,
    NoopAnimationsModule,
    FormsModule,
    HttpClientModule,
    ToastrModule.forRoot(),
    ToastContainerModule,
    BrowserAnimationsModule
  ],
  providers: [],
  bootstrap: [AppComponent]
})
export class AppModule { }
