import { useMemo } from 'react';
// types
import { Service } from 'src/schemas';
// swr
import useSWR from 'swr';
import { endpoints, fetcher } from 'src/utils/axios';

export function useGetServices() {
  const { data, isLoading, error, isValidating } = useSWR<Service[]>(
    endpoints.service,
    () => fetcher<Service[]>(endpoints.service),
    {
      revalidateOnFocus: false,
    }
  );

  const memoizedValue = useMemo(
    () => ({
      services: data || [],
      servicesLoading: isLoading,
      servicesError: error,
      servicesValidating: isValidating,
      servicesEmpty: !isLoading && !data?.length,
    }),
    [data, error, isLoading, isValidating]
  );

  return memoizedValue;
}
