import { NextRequest, NextResponse } from 'next/server';
import { customerSchema } from 'src/schemas';
import prisma from 'src/lib/prisma';
import { authenticateRequest } from 'src/lib/auth-middleware';

export async function PATCH(request: NextRequest, { params }: { params: { id: string } }) {
  try {
    const userId = await authenticateRequest(request);
    if (!userId) {
      return NextResponse.json({ error: 'Unauthorized' }, { status: 401 });
    }

    const body = await request.json();
    const validatedData = customerSchema.partial().parse(body);

    const customer = await prisma.client.update({
      where: { id: params.id },
      data: {
        ...validatedData,
        bankAccounts: undefined,
      },
    });

    return NextResponse.json(customer);
  } catch (error) {
    return NextResponse.json({ error: 'Internal Server Error' }, { status: 500 });
  }
}
