import { useMemo } from 'react';
// routes
import { paths } from 'src/routes/paths';
// components
import SvgColor from 'src/components/svg-color';

// ----------------------------------------------------------------------

const icon = (name: string) => (
  <SvgColor src={`/assets/icons/navbar/${name}.svg`} sx={{ width: 1, height: 1 }} />
  // OR
  // <Iconify icon="fluent:mail-24-filled" />
  // https://icon-sets.iconify.design/solar/
  // https://www.streamlinehq.com/icons
);

const ICONS = {
  job: icon('ic_job'),
  blog: icon('ic_blog'),
  chat: icon('ic_chat'),
  mail: icon('ic_mail'),
  user: icon('ic_user'),
  file: icon('ic_file'),
  lock: icon('ic_lock'),
  tour: icon('ic_tour'),
  order: icon('ic_order'),
  label: icon('ic_label'),
  blank: icon('ic_blank'),
  kanban: icon('ic_kanban'),
  folder: icon('ic_folder'),
  banking: icon('ic_banking'),
  booking: icon('ic_booking'),
  invoice: icon('ic_invoice'),
  product: icon('ic_product'),
  calendar: icon('ic_calendar'),
  disabled: icon('ic_disabled'),
  external: icon('ic_external'),
  menuItem: icon('ic_menu_item'),
  ecommerce: icon('ic_ecommerce'),
  analytics: icon('ic_analytics'),
  dashboard: icon('ic_dashboard'),
};

// ----------------------------------------------------------------------

export function useNavData() {
  const data = useMemo(
    () => [
      // OVERVIEW
      // ----------------------------------------------------------------------
      {
        subheader: 'analytics',
        items: [
          {
            title: 'dashboard',
            path: paths.dashboard.banking,
            icon: ICONS.banking,
          },
        ],
      },

      // MANAGEMENT
      // ----------------------------------------------------------------------
      {
        subheader: 'management',
        items: [
          // INVOICE
          {
            title: 'invoice',
            path: paths.dashboard.invoice.root,
            icon: ICONS.invoice,
            children: [
              { title: 'list', path: paths.dashboard.invoice.root },
              { title: 'create', path: paths.dashboard.invoice.new },
            ],
          },
          // CUSTOMER
          {
            title: 'customer',
            path: paths.dashboard.customer.list,
            icon: ICONS.user,
            children: [
              { title: 'list', path: paths.dashboard.customer.list },
              { title: 'create', path: paths.dashboard.customer.new },
            ],
          },
          {
            title: 'Employees',
            path: paths.dashboard.employee.list,
            icon: <SvgColor src="/assets/icons/navbar/ic_user.svg" />,
            children: [
              { title: 'list', path: paths.dashboard.employee.list },
              { title: 'create', path: paths.dashboard.employee.new },
            ],
          },
        ],
      },
    ],
    []
  );

  return data;
}
