// ----------------------------------------------------------------------

const ROOTS = {
  AUTH: '/auth',
  DASHBOARD: '/dashboard',
};

// ----------------------------------------------------------------------

export const paths = {
  mvpmastersUI: 'https://mvpmasters.com',
  // AUTH
  auth: {
    firebase: {
      login: `${ROOTS.AUTH}/firebase/login`,
      // verify: `${ROOTS.AUTH}/firebase/verify`,
      // register: `${ROOTS.AUTH}/firebase/register`,
      // forgotPassword: `${ROOTS.AUTH}/firebase/forgot-password`,
    },
  },
  // DASHBOARD
  dashboard: {
    root: `${ROOTS.DASHBOARD}`,
    banking: `${ROOTS.DASHBOARD}`,
    invoice: {
      root: `${ROOTS.DASHBOARD}/invoice`,
      new: `${ROOTS.DASHBOARD}/invoice/new`,
      details: (id: string) => `${ROOTS.DASHBOARD}/invoice/${id}`,
      edit: (id: string) => `${ROOTS.DASHBOARD}/invoice/${id}/edit`,
      copy: (id: string) => `${ROOTS.DASHBOARD}/invoice/${id}/copy`,
    },
    customer: {
      new: `${ROOTS.DASHBOARD}/customer/new`,
      list: `${ROOTS.DASHBOARD}/customer/list`,
    },
    employee: {
      root: '/dashboard/employee',
      list: '/dashboard/employee/list',
      new: '/dashboard/employee/new',
      edit: (id: string) => `/dashboard/employee/${id}/edit`,
    },
  },
};
