import { z } from 'zod';

export const employeeTableFilterValueSchema = z.union([z.string(), z.array(z.string())]);

export const employeeTableFiltersSchema = z.object({
  name: z.string(),
  status: z.string(),
});

export const employeeStatusSchema = z.union([z.literal('active'), z.literal('inactive')]);

export const employeeSchema = z.object({
  id: z.string().optional(),
  name: z.string(),
  email: z.string().email(),
  status: employeeStatusSchema.optional(),
  iban: z.string().optional(),
  cv: z.string().optional(),
  photo: z.string().optional(),
  project: z.string().optional(),
});

export const newEmployeeSchema = employeeSchema
  .omit({
    id: true,
  })
  .extend({
    status: employeeStatusSchema,
  });
