import { z } from 'zod';
import {
  createInvoiceSchema,
  invoiceItemSchema,
  invoiceSchema,
  invoiceStatusSchema,
  invoiceTableFilterValueSchema,
  invoiceTableFiltersSchema,
  monthSchema,
  serviceSchema,
  updateInvoiceSchema,
} from '../invoice';

export type InvoiceTableFilterValue = z.infer<typeof invoiceTableFilterValueSchema>;
export type InvoiceTableFilters = z.infer<typeof invoiceTableFiltersSchema>;

export type Service = z.infer<typeof serviceSchema>;
export type InvoiceItem = z.infer<typeof invoiceItemSchema>;
export type InvoiceStatus = z.infer<typeof invoiceStatusSchema>;
export type Month = z.infer<typeof monthSchema>;
export type Invoice = z.infer<typeof invoiceSchema>;
export type CreateInvoice = z.infer<typeof createInvoiceSchema>;
export type UpdateInvoice = z.infer<typeof updateInvoiceSchema>;
