// @mui
import Typography from '@mui/material/Typography';
import Paper, { PaperProps } from '@mui/material/Paper';
import Stack, { StackProps } from '@mui/material/Stack';
// types
import { Customer } from 'src/schemas';
// components
import Label from 'src/components/label';
import { createFullAddress } from 'src/utils/create-full-address';

// ----------------------------------------------------------------------

type Props = PaperProps &
  StackProps & {
    action?: React.ReactNode;
    company: Customer;
  };

export default function AddressItem({ company, action, sx, ...other }: Props) {
  const { name, address, phoneNumber } = company;

  return (
    <Stack
      component={Paper}
      spacing={2}
      alignItems={{ md: 'flex-end' }}
      direction={{ xs: 'column', md: 'row' }}
      sx={{
        position: 'relative',
        ...sx,
      }}
      {...other}
    >
      <Stack flexGrow={1} spacing={1}>
        <Stack direction="row" alignItems="center">
          <Typography variant="subtitle2">{name}</Typography>

          <Label color="info" sx={{ ml: 1 }}>
            Default
          </Label>
        </Stack>

        <Typography variant="body2" sx={{ color: 'text.secondary' }}>
          {createFullAddress(address)}
        </Typography>

        <Typography variant="body2" sx={{ color: 'text.secondary' }}>
          {phoneNumber}
        </Typography>
      </Stack>

      {action && action}
    </Stack>
  );
}
