import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function main() {
  // Clear existing data
  await prisma.service.deleteMany();
  await prisma.tenant.deleteMany();

  // Define default tenant data
  const tenantData = {
    name: "Default Company",
    email: "contact@defaultcompany.com",
    address: {
      street: "123 Business Street",
      city: "Business City",
      state: "BS",
      zip: "12345",
      country: "United States"
    },
    phoneNumber: "+1 234 567 8900",
    representative: "John Doe",
    lastInvoiceNumber: "1",
    logoUrl: "https://example.com/default-logo.png",
    vatNumber: "VAT123456789",
    companyNumber: "COMP123456",
    bankAccounts: {
      eur: {
        accountNumber: "1234567890",
        routingNumber: "987654321",
        bicSwift: "DEFBANKXXX",
        iban: "DE89370400440532013000"
      },
      usd: {
        accountNumber: "0987654321",
        routingNumber: "123456789",
        bicSwift: "DEFBANKXXX",
        iban: "US89370400440532013000"
      }
    },
    // Add services along with the tenant creation
    services: {
      create: [
        {
          name: "Web Development",
          sprint: 5000,
          hour: 150,
          month: 8000
        },
        {
          name: "UI/UX Design",
          sprint: 3000,
          hour: 120,
          month: 6000
        },
        {
          name: "Consulting",
          sprint: 4000,
          hour: 200,
          month: 7000
        }
      ]
    }
  };

  // Create default tenant with services
  const defaultTenant = await prisma.tenant.create({
    data: tenantData,
    include: {
      services: true
    }
  });

  console.log('Seeded default tenant:', defaultTenant);

  console.log('🌱 Seeding database...');

  console.log('✅ Seeding complete!');
}

main()
  .catch((e) => {
    console.error('Error seeding database:', e);
    process.exit(1);
  })
  .finally(async () => {
    await prisma.$disconnect();
  });
