import { useMemo } from 'react';
import { Tenant } from 'src/schemas';
import { endpoints, fetcher } from 'src/utils/axios';
import useSWR from 'swr';

export function useGetTenant() {
  const { data, isLoading, error, isValidating } = useSWR(endpoints.tenant, fetcher<Tenant>, {
    revalidateOnFocus: false,
  });

  const memoizedValue = useMemo(
    () => ({
      settings: data || null,
      settingsLoading: isLoading,
      settingsError: error,
      settingsValidating: isValidating,
      settingsEmpty: !isLoading && !data,
    }),
    [data, error, isLoading, isValidating]
  );

  return memoizedValue;
}
