import { z } from 'zod';

export const customerTableFilterValueSchema = z.union([z.string(), z.array(z.string())]);

export const customerTableFiltersSchema = z.object({
  name: z.string(),
  role: z.array(z.string()),
  status: z.string(),
});

export const addressSchema = z.object({
  street: z.string(),
  city: z.string().optional(),
  country: z.string(),
  state: z.string().optional(),
  zip: z.string(),
});

export const bankAccountSchema = z.object({
  accountNumber: z.string().optional(),
  bicSwift: z.string().optional(),
  iban: z.string().optional(),
  routingNumber: z.string().optional(),
});

export const customerStatusSchema = z.union([
  z.literal('active'),
  z.literal('banned'),
  z.literal('inactive'),
]);

export const customerSchema = z.object({
  id: z.string().optional(),
  name: z.string(),
  email: z.string(),
  address: addressSchema,
  logoUrl: z.string().optional(),
  phoneNumber: z.string().optional(),
  vatNumber: z.string().optional(),
  companyNumber: z.string().optional(),
  representative: z.string(),
  status: customerStatusSchema.optional(),
});

export const tenantSchema = customerSchema
  .omit({
    companyId: true,
    status: true,
  })
  .extend({
    lastInvoiceNumber: z.string(),
  });

export const newCustomerSchema = z.object({
  name: z.string(),
  email: z.string(),
  address: addressSchema,
  logoUrl: z.any().nullable().optional(),
  phoneNumber: z.string().optional(),
  vatNumber: z.string().optional(),
  companyNumber: z.string().optional(),
  representative: z.string(),
  status: customerStatusSchema,
});
