import { z } from 'zod';
import {
  addressSchema,
  bankAccountSchema,
  customerSchema,
  customerStatusSchema,
  customerTableFilterValueSchema,
  customerTableFiltersSchema,
  newCustomerSchema,
  tenantSchema,
} from '../customer';

export type CustomerTableFilters = z.infer<typeof customerTableFiltersSchema>;
export type CustomerTableFilterValue = z.infer<typeof customerTableFilterValueSchema>;

export type Address = z.infer<typeof addressSchema>;
export type BankAccount = z.infer<typeof bankAccountSchema>;
export type CustomerStatus = z.infer<typeof customerStatusSchema>;
export type Customer = z.infer<typeof customerSchema>;
export type NewCustomer = z.infer<typeof newCustomerSchema>;
export type Tenant = z.infer<typeof tenantSchema>;
