import { useFormContext } from 'react-hook-form';
// @mui
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';
import Divider from '@mui/material/Divider';
import IconButton from '@mui/material/IconButton';
import Typography from '@mui/material/Typography';
// hooks
import { useGetTenant } from 'src/api/tenant';
import { useBoolean } from 'src/hooks/use-boolean';
import { useResponsive } from 'src/hooks/use-responsive';
// components
import Iconify from 'src/components/iconify';
//
import { createFullAddress } from 'src/utils/create-full-address';
import { useGetCustomers } from 'src/api/customer';
import { CompanyListDialog } from '../company';

// ----------------------------------------------------------------------

export default function InvoiceNewEditAddress() {
  const {
    watch,
    setValue,
    formState: { errors },
  } = useFormContext();

  const mdUp = useResponsive('up', 'md');

  const values = watch();

  const { invoiceFrom, invoiceTo } = values;

  const { settings: tenant } = useGetTenant();
  const { customers } = useGetCustomers();

  const from = useBoolean();
  const to = useBoolean();

  return (
    <>
      <Stack
        spacing={{ xs: 3, md: 5 }}
        direction={{ xs: 'column', md: 'row' }}
        divider={
          <Divider
            flexItem
            orientation={mdUp ? 'vertical' : 'horizontal'}
            sx={{ borderStyle: 'dashed' }}
          />
        }
        sx={{ p: 3 }}
      >
        <Stack sx={{ width: 1 }}>
          <Stack direction="row" alignItems="center" sx={{ mb: 1 }}>
            <Typography variant="h6" sx={{ color: 'text.disabled', flexGrow: 1 }}>
              From:
            </Typography>
            <IconButton onClick={from.onTrue}>
              <Iconify icon="solar:pen-bold" />
            </IconButton>
          </Stack>

          {invoiceFrom ? (
            <Stack spacing={1}>
              <Typography variant="subtitle2">{invoiceFrom.name}</Typography>
              <Typography variant="body2">{createFullAddress(invoiceFrom.address)}</Typography>
              <Typography variant="body2"> {invoiceFrom.phoneNumber}</Typography>
            </Stack>
          ) : (
            <Typography typography="caption" sx={{ color: 'error.main' }}>
              {(errors.invoiceFrom as any)?.message}
            </Typography>
          )}
        </Stack>

        <Stack sx={{ width: 1 }}>
          <Stack direction="row" alignItems="center" sx={{ mb: 1 }}>
            <Typography variant="h6" sx={{ color: 'text.disabled', flexGrow: 1 }}>
              To:
            </Typography>

            <IconButton onClick={to.onTrue}>
              <Iconify icon={invoiceTo ? 'solar:pen-bold' : 'mingcute:add-line'} />
            </IconButton>
          </Stack>

          {invoiceTo ? (
            <Stack spacing={1}>
              <Typography variant="subtitle2">{invoiceTo.name}</Typography>
              <Typography variant="body2">{createFullAddress(invoiceTo.address)}</Typography>
              <Typography variant="body2"> {invoiceTo.phoneNumber}</Typography>
            </Stack>
          ) : (
            <Typography typography="caption" sx={{ color: 'error.main' }}>
              {(errors.invoiceTo as any)?.message}
            </Typography>
          )}
        </Stack>
      </Stack>

      {tenant && (
        <CompanyListDialog
          title="Companies"
          open={from.value}
          onClose={from.onFalse}
          selected={(selectedId: string) => invoiceFrom?.id === selectedId}
          onSelect={(tenant) => setValue('invoiceFrom', tenant)}
          tenant={tenant}
          action={
            <Button
              size="small"
              startIcon={<Iconify icon="mingcute:add-line" />}
              sx={{ alignSelf: 'flex-end' }}
            >
              New
            </Button>
          }
        />
      )}

      <CompanyListDialog
        title="Customers"
        open={to.value}
        onClose={to.onFalse}
        selected={(selectedId: string) => invoiceTo?.id === selectedId}
        onSelect={(company) => setValue('invoiceTo', company)}
        list={customers}
        action={
          <Button
            size="small"
            startIcon={<Iconify icon="mingcute:add-line" />}
            sx={{ alignSelf: 'flex-end' }}
          >
            New
          </Button>
        }
      />
    </>
  );
}
