import { Invoice } from 'src/schemas';
import InvoiceEEPDF from './invoice-ee-pdf';
import InvoiceMKPDF from './invoice-mk-pdf';

type Props = {
  invoice: Invoice;
  currentStatus: string;
};

export default function InvoicePDF({ invoice, currentStatus }: Props) {
  return invoice.invoiceFrom.companyNumber === '16911123' ? (
    <InvoiceEEPDF invoice={invoice} currentStatus={currentStatus} />
  ) : (
    <InvoiceMKPDF invoice={invoice} currentStatus={currentStatus} />
  );
}
