import { Address } from 'src/schemas';

export function createFullAddress(data: Address): string {
  const { street, city, state, zip, country } = data;

  const components = [street];

  // Combine city, state, and zip with appropriate commas
  const cityStateZip = [];
  if (city) cityStateZip.push(city);
  if (state) cityStateZip.push(state);
  if (zip) cityStateZip.push(zip);

  if (cityStateZip.length) {
    components.push(cityStateZip.join(', ')); // Use comma-space for separation within this group
  }

  if (country) components.push(country);

  return components.join('\n').trim(); // Use just a newline for separation between major components
}
