import useSWR from 'swr';
import axios from 'src/utils/axios';
import { InvoiceStatus } from 'src/schemas';

interface StatusTotals {
  EUR: number;
  USD: number;
}

export interface AnalyticsResults {
  total: StatusTotals;
  processing: StatusTotals;
  paid: StatusTotals;
  pending: StatusTotals;
  overdue: StatusTotals;
  draft: StatusTotals;
}

async function fetchAnalytics(startDate: Date) {
  const { data } = await axios.get<AnalyticsResults>('/api/invoices/totals', {
    params: { startDate: startDate.toISOString() },
    withCredentials: true,
    headers: {
      'Content-Type': 'application/json',
    },
  });
  return data;
}

export function useFetchAnalytics(startDate: Date | null) {
  const { data, error, isLoading } = useSWR(
    startDate ? ['invoiceTotals', startDate] : null,
    () => startDate && fetchAnalytics(startDate),
    {
      revalidateOnFocus: false,
      shouldRetryOnError: false,
    }
  );

  return {
    analytics: data,
    analyticsError: error,
    isAnalyticsLoading: isLoading,
  };
}
