import { NextRequest, NextResponse } from 'next/server';
import { customerSchema } from 'src/schemas';
import prisma from 'src/lib/prisma';
import { authenticateRequest } from 'src/lib/auth-middleware';

export async function PATCH(request: NextRequest, { params }: { params: { id: string } }) {
  try {
    const auth = await authenticateRequest(request);
    if (!auth || auth instanceof NextResponse) {
      return NextResponse.json({ error: 'Unauthorized' }, { status: 401 });
    }

    const { userId, tenantId } = auth;

    const body = await request.json();
    const validatedData = customerSchema.partial().parse(body);

    console.log('validatedData', validatedData);

    const customer = await prisma.client.update({
      where: { id: params.id },
      data: {
        ...validatedData,
        tenantId,
      },
    });

    return NextResponse.json(customer);
  } catch (error) {
    return NextResponse.json({ error: 'Internal Server Error' }, { status: 500 });
  }
}
