# Project Setup Guide

This guide will help you set up and run the project locally.

## Prerequisites

- Node.js (v16.x or v18.x)
- Yarn (recommended) or npm
- Access to project's database credentials
- Google Cloud credentials

## Installation Steps

1. **Install Dependencies**

   ```bash
   yarn install
   # or using npm
   npm install --legacy-peer-deps
   ```

2. **Database Connection**

   Open a terminal and run the following SSH command to establish a connection to the database:

   ```bash
   ssh -L 5432:localhost:5432 t_agency_os@194.149.135.130 -N
   ```

   Keep this terminal window open while working with the application.

3. **Environment Setup**

   Update the `.env` file with your Google Cloud credentials:

   ```env
   GOOGLE_APPLICATION_CREDENTIALS="/path/to/your/credentials.json"
   ```

4. **Generate Prisma Client**

   ```bash
   yarn prisma:generate
   ```

5. **Seed Database (First-time setup)**

   If you're setting up the project for the first time and the database is empty, run:

   ```bash
   yarn db:seed
   ```

   This will create an initial tenant and user in the database.

6. **Start Development Server**
   ```bash
   yarn dev
   ```
   The application should now be running on `http://localhost:3000`

## Authentication

The application uses Firebase Authentication. You can log in with the following default credentials:

- Email: naum@mvpmasters.com
- Password: BnP2025~

## Available Scripts

- `yarn dev` - Start development server
- `yarn prisma:generate` - Generate Prisma client
- `yarn build` - Build for production
- `yarn start` - Start production server
- `yarn db:seed` - Seed the database with initial data

## Troubleshooting

If you encounter any issues:

- Ensure the SSH connection to the database is active
- Verify your Google Cloud credentials path is correct
- Check if all environment variables are properly set
- Make sure the database is properly seeded if you're setting up for the first time

## Support

For additional help or questions, please contact the development team.
