import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function main() {
  console.log('🌱 Seeding database...');

  // Create Customers
  const customer1 = await prisma.customer.create({
    data: {
      name: 'Acme Corp',
      email: 'contact@acme.com',
      street: '123 Main St',
      city: 'New York',
      country: 'USA',
      state: 'NY',
      zip: '10001',
      phoneNumber: '+1 555-555-5555',
      vatNumber: 'US123456789',
      companyNumber: '123456789',
      representative: 'John Doe',
      status: 'ACTIVE',
      logoUrl: 'https://example.com/logo.png',
    },
  });

  const customer2 = await prisma.customer.create({
    data: {
      name: 'Globex Ltd.',
      email: 'info@globex.com',
      street: '456 Industrial Rd',
      city: 'Los Angeles',
      country: 'USA',
      state: 'CA',
      zip: '90001',
      phoneNumber: '+1 555-123-4567',
      vatNumber: 'US987654321',
      companyNumber: '987654321',
      representative: 'Jane Smith',
      status: 'INACTIVE',
      logoUrl: 'https://example.com/logo2.png',
    },
  });

  // Create Bank Accounts
  await prisma.bankAccount.createMany({
    data: [
      {
        customerId: customer1.id,
        accountNumber: '1234567890',
        bicSwift: 'ACMEUS33',
        iban: 'US12345678901234567890',
        routingNumber: '111000025',
        currency: 'USD',
      },
      {
        customerId: customer2.id,
        accountNumber: '0987654321',
        bicSwift: 'GLOBEXUS12',
        iban: 'US09876543210987654321',
        routingNumber: '222000033',
        currency: 'EUR',
      },
    ],
  });

  // Create Services
  const service1 = await prisma.service.create({
    data: {
      name: 'Web Development',
      sprintPrice: 5000.0,
      hourPrice: 100.0,
      monthPrice: 20000.0,
    },
  });

  const service2 = await prisma.service.create({
    data: {
      name: 'SEO Optimization',
      sprintPrice: 3000.0,
      hourPrice: 75.0,
      monthPrice: 12000.0,
    },
  });

  // Create Invoices
  const invoice1 = await prisma.invoice.create({
    data: {
      dueDate: new Date('2025-03-15'),
      status: 'PENDING',
      currency: 'USD',
      quantityType: 'HOUR',
      subTotal: 5000.0,
      createDate: new Date(),
      month: 'FEBRUARY',
      discount: 0.0,
      taxes: 500.0,
      totalAmount: 5500.0,
      invoiceNumber: 'INV-2025-001',
      pdfRef: 'https://example.com/invoice1.pdf',
      invoiceFromId: customer1.id,
      invoiceToId: customer2.id,
    },
  });

  // Create Invoice Items
  await prisma.invoiceItem.create({
    data: {
      title: 'Web Development - Sprint 1',
      price: 5000.0,
      total: 5000.0,
      quantity: 1,
      description: 'Development of the MVP frontend',
      serviceId: service1.id,
      invoiceId: invoice1.id,
    },
  });

  console.log('✅ Seeding complete!');
}

main()
  .catch((e) => {
    console.error(e);
    process.exit(1);
  })
  .finally(async () => {
    await prisma.$disconnect();
  });
