import { useMemo } from 'react';
// types
import { Invoice } from 'mvpmasters-shared';
// db
import useSWR from 'swr';
import { endpoints, fetcher } from 'src/utils/axios';

interface InvoiceFilters {
  name?: string;
  service?: string[];
  status?: string;
  startDate?: string | null;
  endDate?: string | null;
}

export function useGetInvoices(params: InvoiceFilters = {}) {
  const collectionName = endpoints.invoice;

  const searchParams = new URLSearchParams();
  if (params.name) searchParams.set('name', params.name);
  if (params.status) searchParams.set('status', params.status);
  if (params.startDate) searchParams.set('startDate', params.startDate);
  if (params.endDate) searchParams.set('endDate', params.endDate);
  if (params.service?.length) {
    params.service.forEach((service) => searchParams.append('service', service));
  }

  const queryString = searchParams.toString();
  const endpoint = queryString ? `${collectionName}?${queryString}` : collectionName;

  const { data, isLoading, error, isValidating } = useSWR(
    endpoint,
    () => fetcher<Invoice[]>(endpoint),
    {
      revalidateOnFocus: false,
    }
  );

  const memoizedValue = useMemo(
    () => ({
      invoices: data || [],
      invoicesLoading: isLoading,
      invoicesError: error,
      invoicesValidating: isValidating,
      invoicesEmpty: !isLoading && !data?.length,
    }),
    [data, error, isLoading, isValidating]
  );

  return memoizedValue;
}

// export function useGetInvoice({ id }: { id: string }) {
//   const collectionName = collections.invoice;

//   const { data, isLoading, error, isValidating } = useSWR(
//     [collectionName, id],
//     () => documentFetcher<Invoice>(collectionName, id),
//     {
//       revalidateOnFocus: false,
//     }
//   );

//   const memoizedValue = useMemo(
//     () => ({
//       currentInvoice: data || null,
//       currentInvoiceLoading: isLoading,
//       currentInvoiceError: error,
//       currentInvoiceValidating: isValidating,
//       currentInvoiceEmpty: !isLoading && !data,
//     }),
//     [data, error, isLoading, isValidating]
//   );

//   return memoizedValue;
// }
