import { NextRequest, NextResponse } from 'next/server';
import { invoiceSchema } from 'mvpmasters-shared';
import prisma from 'src/lib/prisma';
import { authenticateRequest } from 'src/lib/auth-middleware';

export async function PATCH(request: NextRequest, { params }: { params: { id: string } }) {
  try {
    // Authenticate the request
    const authResult = await authenticateRequest(request);
    if (authResult instanceof NextResponse) {
      return authResult;
    }
    const { userId } = authResult;

    const body = await request.json();
    const validatedData = invoiceSchema.partial().parse(body);

    const invoice = await prisma.invoice.update({
      where: { id: params.id, userId },
      data: {
        ...validatedData,
        items: validatedData.items
          ? {
              deleteMany: {},
              create: validatedData.items,
            }
          : undefined,
      },
      include: {
        items: {
          include: {
            service: true,
          },
        },
        invoiceFrom: true,
        invoiceTo: true,
      },
    });

    return NextResponse.json(invoice);
  } catch (error) {
    return NextResponse.json({ error: 'Internal Server Error' }, { status: 500 });
  }
}
