import { useMemo } from 'react';
// types
import { Service } from 'mvpmasters-shared';
// db
import { collections, collectionFetcher as fetcher } from 'src/lib/firestore';
// swr
import useSWR from 'swr';

export function useGetServices() {
  const collectionName = collections.service;

  const { data, isLoading, error, isValidating } = useSWR(collectionName, fetcher<Service>, {
    revalidateOnFocus: false,
  });

  const memoizedValue = useMemo(
    () => ({
      services: data || [],
      servicesLoading: isLoading,
      servicesError: error,
      servicesValidating: isValidating,
      servicesEmpty: !isLoading && !data?.length,
    }),
    [data, error, isLoading, isValidating]
  );

  return memoizedValue;
}
