import { useMemo } from 'react';
// types
import { Settings } from 'src/types/settings';
// db
import { collections, collectionFetcher as fetcher } from 'src/lib/firestore';
// swr
import useSWR from 'swr';

export function useGetSettings() {
  const collectionName = collections.settings;

  const { data, isLoading, error, isValidating } = useSWR(collectionName, fetcher<Settings>, {
    revalidateOnFocus: false,
  });

  const dataObject = transformArrayToObject(data);

  const memoizedValue = useMemo(
    () => ({
      settings: dataObject || null,
      settingsLoading: isLoading,
      settingsError: error,
      settingsValidating: isValidating,
      settingsEmpty: !isLoading && !dataObject,
    }),
    [dataObject, error, isLoading, isValidating]
  );

  return memoizedValue;
}

const transformArrayToObject = (data?: Settings[]): Settings | undefined => {
  if (!data) return undefined;

  return data.reduce((accumulator: Settings, doc) => {
    const { id, ...fields } = doc;
    accumulator[id as keyof Settings] = fields;
    return accumulator;
  }, {} as Settings);
};
