import { NextRequest, NextResponse } from 'next/server';
import { auth } from 'src/lib/firebase-admin';

export interface AuthenticatedRequest extends NextRequest {
  userId: string;
}

export async function authenticateRequest(
  request: NextRequest
): Promise<{ userId: string } | NextResponse> {
  // Get the authorization header
  const authHeader = request.headers.get('Authorization');
  if (!authHeader?.startsWith('Bearer ')) {
    return NextResponse.json({ error: 'Unauthorized' }, { status: 401 });
  }

  // Extract the token
  const token = authHeader.split('Bearer ')[1];

  try {
    // Verify the token
    const decodedToken = await auth.verifyIdToken(token);
    const userId = decodedToken.uid;

    if (!userId) {
      return NextResponse.json({ error: 'Unauthorized' }, { status: 401 });
    }

    return { userId };
  } catch (error) {
    return NextResponse.json({ error: 'Unauthorized' }, { status: 401 });
  }
}
