const admin = require('firebase-admin');
const serviceAccount = require('../service-account.json');

// Initialize Firebase Admin
admin.initializeApp({
  credential: admin.credential.cert(serviceAccount)
});

async function verifyUserEmail() {
  const uid = 'dK2y3WezYWWltHCaBRvUFlddkOr2';

  try {
    // Update the user's email verified status
    await admin.auth().updateUser(uid, {
      emailVerified: true,
    });

    // Get the updated user to confirm
    const user = await admin.auth().getUser(uid);
    console.log('User email verified successfully');
    console.log('User details:', user.toJSON());
  } catch (error) {
    console.error('Error verifying user email:', error);
  }
}

// Run the function
verifyUserEmail(); 