import { NextResponse } from 'next/server';
import { authenticateRequest } from 'src/lib/auth-middleware';
import { type NextRequest } from 'next/server';
import prisma from 'src/lib/prisma';

export async function GET(request: NextRequest) {
  try {
    const authResult = await authenticateRequest(request);

    if (authResult instanceof NextResponse) {
      return authResult;
    }

    // Get user from Prisma
    const user = await prisma.user.findUnique({
      where: {
        id: authResult.userId,
      },
    });

    if (!user) {
      return NextResponse.json({ error: 'User not found' }, { status: 404 });
    }

    return NextResponse.json(user);
  } catch (error) {
    console.error(error);
    return NextResponse.json({ error: 'Internal server error' }, { status: 500 });
  }
}
