// sections
import { NotFoundView } from 'src/sections/error';
import Link from 'next/link';

// ----------------------------------------------------------------------

export const metadata = {
  title: '404 Page Not Found!',
};

export default function NotFound() {
  return (
    <div className="flex min-h-screen flex-col items-center justify-center">
      <h2 className="text-2xl font-bold mb-4">Page Not Found</h2>
      <p className="mb-4">Could not find requested resource</p>
      <Link href="/" className="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
        Return Home
      </Link>
    </div>
  );
}
