import { z } from 'zod';
import { userSchema, userRoleSchema } from '../user';

export type User = z.infer<typeof userSchema>;
export type UserRole = z.infer<typeof userRoleSchema>;
export type NewUser = Omit<User, 'id'>;
export type UpdateUser = Omit<User, 'id' | 'uid' | 'tenantId'>;
