import { useFormContext, Controller } from 'react-hook-form';
// @mui
import { DatePicker } from '@mui/x-date-pickers/DatePicker';
import Stack from '@mui/material/Stack';
import MenuItem from '@mui/material/MenuItem';
// components
import { RHFSelect, RHFTextField } from 'src/components/hook-form';
// api
// import { useGetTenant } from 'src/api/settings';
// utils
import { incrementInvoiceNumber } from 'src/utils/increment-invoice-number';

export const monthNames = [
  'January',
  'February',
  'March',
  'April',
  'May',
  'June',
  'July',
  'August',
  'September',
  'October',
  'November',
  'December',
];

// ----------------------------------------------------------------------

export default function InvoiceNewEditStatusDate({ isCopy }: { isCopy?: boolean }) {
  const { control, watch } = useFormContext();

  const values = watch();

  // const { settings } = useGetTenant();

  return (
    <Stack
      spacing={2}
      direction={{ xs: 'column', sm: 'row' }}
      sx={{ p: 3, bgcolor: 'background.neutral' }}
    >
      {isCopy ? (
        <RHFTextField
          disabled
          name="invoiceNumber"
          label="Invoice number"
          value={values.invoiceNumber}
        />
      ) : (
        <RHFTextField name="invoiceNumber" label="Invoice number" value={values.invoiceNumber} />
      )}

      <RHFSelect
        fullWidth
        name="month"
        label="Month"
        InputLabelProps={{ shrink: true }}
        PaperPropsSx={{ textTransform: 'uppercase' }}
      >
        {monthNames.map((option) => (
          <MenuItem key={option} value={option}>
            {option}
          </MenuItem>
        ))}
      </RHFSelect>

      <RHFSelect
        fullWidth
        name="status"
        label="Status"
        InputLabelProps={{ shrink: true }}
        PaperPropsSx={{ textTransform: 'capitalize' }}
      >
        {['paid', 'pending', 'overdue', 'draft'].map((option) => (
          <MenuItem key={option} value={option}>
            {option}
          </MenuItem>
        ))}
      </RHFSelect>

      <RHFSelect
        fullWidth
        name="currency"
        label="Currency"
        InputLabelProps={{ shrink: true }}
        PaperPropsSx={{ textTransform: 'uppercase' }}
      >
        {['EUR', 'USD'].map((option) => (
          <MenuItem key={option} value={option}>
            {option}
          </MenuItem>
        ))}
      </RHFSelect>

      <RHFSelect
        fullWidth
        name="quantityType"
        label="Quantity Type"
        InputLabelProps={{ shrink: true }}
        PaperPropsSx={{ textTransform: 'uppercase' }}
      >
        {['Unit', 'Hour', 'Sprint', 'Month'].map((option) => (
          <MenuItem key={option} value={option}>
            {option}
          </MenuItem>
        ))}
      </RHFSelect>

      <Controller
        name="issueDate"
        control={control}
        render={({ field, fieldState: { error } }) => (
          <DatePicker
            label="Date issued"
            value={field.value}
            onChange={(newValue) => {
              field.onChange(newValue);
            }}
            slotProps={{
              textField: {
                fullWidth: true,
                error: !!error,
                helperText: error?.message,
              },
            }}
          />
        )}
      />

      <Controller
        name="dueDate"
        control={control}
        render={({ field, fieldState: { error } }) => (
          <DatePicker
            label="Due date"
            value={field.value}
            onChange={(newValue) => {
              field.onChange(newValue);
            }}
            slotProps={{
              textField: {
                fullWidth: true,
                error: !!error,
                helperText: error?.message,
              },
            }}
          />
        )}
      />
    </Stack>
  );
}
