import { NextRequest, NextResponse } from 'next/server';
import { auth } from 'src/lib/firebase-admin';

export interface AuthenticatedRequest extends NextRequest {
  userId: string;
  tenantId: string;
}

export async function authenticateRequest(
  request: NextRequest
): Promise<{ userId: string; tenantId: string } | NextResponse> {
  // Get the authorization header
  const authHeader = request.headers.get('Authorization');
  if (!authHeader?.startsWith('Bearer ')) {
    return NextResponse.json({ error: 'Unauthorized' }, { status: 401 });
  }

  // Extract the token
  const token = authHeader.split('Bearer ')[1];

  try {
    // Verify the token
    const decodedToken = await auth.verifyIdToken(token);
    const userId = decodedToken.uid;

    const tenantId = decodedToken.customClaims?.tenantId || 'cm7lxc3p00000pb7kmdrxsfod';

    if (!userId || !tenantId) {
      return NextResponse.json({ error: 'Unauthorized' }, { status: 401 });
    }

    return { userId, tenantId: 'cm7lxc3p00000pb7kmdrxsfod' };
  } catch (error) {
    console.error('Error verifying token:', error);
    return NextResponse.json({ error: 'Unauthorized' }, { status: 401 });
  }
}
