import { z } from 'zod';

export const userRoleSchema = z.union([
  z.literal('ADMIN'),
  z.literal('MANAGER'),
  z.literal('USER'),
]);

export const userSchema = z.object({
  id: z.string().optional(),
  uid: z.string(),
  email: z.string().email(),
  displayName: z.string(),
  role: userRoleSchema,
  tenantId: z.string(),
});

export const newUserSchema = userSchema.omit({
  id: true,
});

export const updateUserSchema = userSchema.omit({
  id: true,
  uid: true,
  tenantId: true,
});
