-- Index Optimization for Client Email Queries
-- This creates an optimized index for queries like: SELECT * FROM "Client" WHERE email = 'test@example.com'

-- Drop existing index if it exists (Prisma may have created a basic one)
DROP INDEX IF EXISTS idx_client_email_basic;

-- Index for client email queries
CREATE INDEX IF NOT EXISTS idx_client_email ON "Client"(email);

-- Index for email + tenant lookups
CREATE INDEX IF NOT EXISTS idx_client_email_tenant ON "Client"(email, tenant_id);

-- Create a case-insensitive index for email searches
-- This allows case-insensitive email lookups using functional index
CREATE INDEX IF NOT EXISTS idx_client_email_lower ON "Client"(LOWER(email));

-- Update table statistics for query planner optimization
ANALYZE "Client"; 